﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns:o= "urn:schemas-microsoft-com:office:office">

<script runat="server">

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool pelneStanowisko = false;
        [Priority(1)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
        
    protected void dc_ContextLoad(object sender, EventArgs e) {
        ReportHeader1["MIEJSCOWOSC"] = GetMiejscowosc();
        
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];

        fieldDataUr.EditValue = ph.Urodzony.Data.ToString();
        if (ph.AdresZamieszkania.Ulica.Length > 0) {
            fieldUlica.EditValue = "ul." + ph.AdresZamieszkania.Ulica;
            fieldNrDomuLokalu.EditValue = ph.AdresZamieszkania.NrDomu;
            fieldNrDomuLokalu.EditValue += (ph.AdresZamieszkania.NrLokalu.Length > 0) ? ("/" + ph.AdresZamieszkania.NrLokalu) : "";
            fieldMiejscowosc.EditValue = ph.AdresZamieszkania.Miejscowosc;
            fieldKodPocztowy.EditValue = ph.AdresZamieszkania.KodPocztowyS;
            fieldPoczta.EditValue = ph.AdresZamieszkania.Poczta;
        } else {
            fieldUlica.EditValue = "ul." + ph.AdresZameldowania.Ulica;
            fieldNrDomuLokalu.EditValue = ph.AdresZameldowania.NrDomu;
            fieldNrDomuLokalu.EditValue += (ph.AdresZameldowania.NrLokalu.Length > 0) ? ("/" + ph.AdresZameldowania.NrLokalu) : "";
            fieldMiejscowosc.EditValue = ph.AdresZameldowania.Miejscowosc;
            fieldKodPocztowy.EditValue = ph.AdresZameldowania.KodPocztowyS;
            fieldPoczta.EditValue = ph.AdresZameldowania.Poczta;
        }
        labelStanowisko.EditValue = GetStanowisko(ph);
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }

    string GetMiejscowosc() {
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = CoreModule.GetInstance(dc).Config.Firma.AdresSiedziby.Miejscowosc;
        return miejscowosc;
    }                
</script>

<head>
    <title>Badania lekarskie - wstępne</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="BadaniaLekarskieWstępne" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" TypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" OnContextLoad="dc_ContextLoad"></ea:datacontext>
        <cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Skierowanie pracownika na wstępne badania lekarskie|%MIEJSCOWOSC%, {0}" runat="server" DataMember0="Context.ActualDate.Actual"></cc1:ReportHeader>
		<font face="Tahoma" size="2">
        <p style="text-align:justify">
            Do: . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br />
            . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
            <br />
            . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
        </p>
        <p style="text-align:justify">
            Kieruję 
            <ea:DataLabel id="DataLabel6" runat="server" Bold="False" DataMember="Plec">
                <ValuesMap>
                    <ea:ValuesPair Key="Kobieta" Value="Panią"></ea:ValuesPair>
                    <ea:ValuesPair Key="Mężczyzna" Value="Pana"></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>
            <ea:DataLabel id="DataLabel5" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:DataLabel>
            &nbsp;<ea:DataLabel id="DataLabel4" runat="server" Bold="False" DataMember="Plec">
                <ValuesMap>
                    <ea:ValuesPair Key="Kobieta" Value="legitymującą"></ea:ValuesPair>
                    <ea:ValuesPair Key="Mężczyzna" Value="legitymującego"></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>
            się dowodem osobistym nr &nbsp;<ea:DataLabel id="DataLabel1" runat="server" DataMember="Dokument.SeriaNumer"></ea:DataLabel>
            (Nr PESEL 
            <ea:DataLabel id="DataLabel2" runat="server" DataMember="PESEL"></ea:DataLabel>),
            <ea:DataLabel id="DataLabel20" runat="server" DataMember="Plec" Bold="False">
                <ValuesMap>
                    <ea:ValuesPair Key="Kobieta" Value="urodzoną"></ea:ValuesPair>
                    <ea:ValuesPair Key="Mężczyzna" Value="urodzonego"></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>
            &nbsp;<ea:DataLabel id="fieldDataUr" runat="server"></ea:DataLabel>
            ,&nbsp;<ea:DataLabel id="DataLabel22" runat="server" DataMember="Plec" Bold="False">
                <ValuesMap>
                    <ea:ValuesPair Key="Kobieta" Value="zamieszkałą"></ea:ValuesPair>
                    <ea:ValuesPair Key="Mężczyzna" Value="zamieszkałego"></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>
            &nbsp;<ea:DataLabel id="fieldUlica" runat="server"></ea:DataLabel>
            &nbsp;<ea:DataLabel id="fieldNrDomuLokalu" runat="server"></ea:DataLabel>
            &nbsp;<ea:DataLabel id="fieldMiejscowosc" runat="server"></ea:DataLabel>
            ,&nbsp;<ea:DataLabel id="fieldKodPocztowy" runat="server"></ea:DataLabel>
            &nbsp;<ea:DataLabel id="fieldPoczta" runat="server"></ea:DataLabel>&nbsp;
            na wstępne badania lekarskie. 
        </p>
        <p style="text-align:justify">
            <ea:DataLabel id="DataLabel7" runat="server" Bold="False" DataMember="Plec">
                <ValuesMap>
                    <ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
                    <ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>
            &nbsp;<ea:DataLabel id="DataLabel8" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:DataLabel>
            &nbsp;ma zostać z dniem 
            <ea:DataLabel id="DataLabel3" runat="server" DataMember="Etat.Okres.From"></ea:DataLabel>
            &nbsp; 
            <ea:DataLabel id="DataLabel9" runat="server" Bold="False" DataMember="Plec">
                <ValuesMap>
                    <ea:ValuesPair Key="Kobieta" Value="zatrudniona"></ea:ValuesPair>
                    <ea:ValuesPair Key="Mężczyzna" Value="zatrudniony"></ea:ValuesPair>
                </ValuesMap>
            </ea:DataLabel>
            w tutejszym zakładzie na stanowisku&nbsp;<ea:DataLabel id="labelStanowisko" runat="server"></ea:DataLabel>
            . 
        </p>
        <p style="text-align:justify">
            Charakterystyka czynności:* 
        </p>
        <blockquote dir="ltr" style="MARGIN-RIGHT: 0px"> 
        <ol>
            <li type="a">
                Praca na wysokości 
            </li>
            <li type="a">
                Prowadzenie pojazdu 
            </li>
            <li type="a">
                Praca przy urządzeniach w ruchu 
            </li>
            <li type="a">
                Kontakt z żywnością 
            </li>
            <li type="a">
                Praca przy komputerze 
            </li>
            <li type="a">
                Zagrożenie wynikające ze stałego dużego dopływu informacji i gotowości do odpowiedzi
                (stanowiska decyzyjne) 
            </li>
            <li type="a">
                Stały wysiłek głosu 
            </li>
            <li type="a">
                Spawanie 
            </li>
            <li type="a">
                Kontakt z lakierami i smarami 
            </li>
            <li type="a">
                Obsługa maszyn i dźwigów 
            </li>
        </ol>
        </blockquote> 
        <p style="text-align:justify">
            Czynniki szkodliwe:* 
        </p>
        <blockquote dir="ltr" style="MARGIN-RIGHT: 0px"> 
        <ol>
            <li type="a">
                Chemiczne:<br />
                CO, CO2, NxOy, Fe, MN, zapylenie, SiO2, BTX (benzen, toluen, ksylen), benzyna ekstrakcyjna,
                butanol, KOH (wodorotlenek wodorotlenek potasu), H2SO4 (kwas siarkowy), nafta i ropopochodne,
                KCI, octan etylu, aceton, amoniak.. 
            </li>
            <li type="a">
                Fizyczne:<br />
                hałas, mikroklimat 
            </li>
            <li type="a">
                Biologiczne 
            </li>
        </ol>
        </blockquote> 
        <p style="text-align:justify">
            Proszę o wydanie orzeczenia lekarskiego o stanie zdrowia pracownika i ustalenie braku
            przeciwwskazań do pracy na proponowanym stanowisku. 
        </p>
        <p style="text-align:justify">
            Podstawa prawna art. 229 § 2 i 4 K.p. 
        </p>
        <p style="text-align:justify">
            <font face="Tahoma" size="1">* niepotrzebne skreślić</font>
        </p>
        <cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
            <Subtitles>
                <cc1:FooterSubtitle SubtitleType="Empty" Width="50"></cc1:FooterSubtitle>
                <cc1:FooterSubtitle Caption="podpis pracodawcy" Width="50"></cc1:FooterSubtitle>
            </Subtitles>
        </cc1:ReportFooter>
	</font>
    </form>
</body>
</html>
